#include "XOPStandardHeaders.h"			// Include ANSI headers, Mac headers, IgorXOP.h, XOP.h and XOPSupport.h
#include "autocorrelation.h"
#include <stdio.h>
#include "stdlib.h"
#include "string.h"
#include "TIFFconstants.h"
#include <iostream>
#include <fstream>
#include <assert.h>
#include <errno.h>
#include "stdafx.h"
#include "atlstr.h"

#define SWAP_4(memblock, k) \
	{ char a = memblock[k]; \
	char b = memblock[k+1]; \
	char c = memblock[k+2]; \
	char d = memblock[k+3]; \
	memblock[k]=d; \
	memblock[k+1]=c; \
	memblock[k+2]=b; \
	memblock[k+3]=a; }

#define SWAP_2(memblock, k) \
	{ char a = memblock[k]; \
	char b = memblock[k+1]; \
	memblock[k]=b; \
	memblock[k+1]=a; }

using namespace std;




#include "XOPStructureAlignmentTwoByte.h"	// All structures passed to Igor are two-byte aligned.
struct xstrcatParams  {

	//double number_imFCS2;
	//double number_imFCS1;
											//Handle str_imFCS4;
	Handle str_imFCS3;
	Handle str_imFCS2;
	
	double result;
};
typedef struct xstrcatParams xstrcatParams;
#include "XOPStructureAlignmentReset.h"

static int xstrcat(xstrcatParams* p)				/* str1 = xstrcat(str2, str3) */
{
	
	
	Handle str1;						/* output handle */
	long len2, len3,len_conv, len_conv1;
											//long len4, len_conv2;
	int err=0;
	char* queen_imFCS ;
	char* vulture_imFCS;
											//char* king_imFCS;
	
	long lengthtrial, lengthtrial1;
											//long lengthtrial2;
	
int hState, hState1;
											//int hState2;
len_conv = GetHandleSize(p->str_imFCS2);
char trialstring[1024];
GetCStringFromHandle(p->str_imFCS2, trialstring, len_conv);
assert(trialstring != NULL);


len_conv1 = GetHandleSize(p->str_imFCS3);
char trialstring1[1024];
GetCStringFromHandle(p->str_imFCS3, trialstring1, len_conv1);
assert(trialstring1 != NULL);




	
	
	str1 = NIL;	

	
	len2 = GetHandleSize(p->str_imFCS2);		/* length of string 2 */
	len3 = GetHandleSize(p->str_imFCS3);
		//len4 = GetHandleSize(p->str_imFCS4);/* length of string 3 */
	str1 = NewHandle(len2 + len3 );	

	memcpy(*str1, *p->str_imFCS2, len2);
	memcpy(*str1+len2, *p->str_imFCS3, len3);
	//memcpy(*str1+len2+ len3, *p->str_imFCS4, len4);




				int start = 1;
					

					int rowvariable = 0;
	struct IFH ifh;
	struct tiffheader tiffh;
	void *m_data;
	FILE * f = fopen(trialstring, "rb");
	assert(f && "couldn't open file");
	fseek(f, SEEK_SET, SEEK_END);
	__int64 filesize = ftell(f);
	if (filesize > 1E9)
		return NOMEM;
	assert(filesize > 0);
	m_data = malloc((size_t)filesize);
	 if(m_data == NULL)
		 return NOMEM;// FIX_ME: bogus cast. 2004121 mortene.
	assert(m_data);

	fseek(f, 0, 0);
	size_t gotnrbytes =	fread(m_data, 1, (size_t)filesize, f);
	//assert(gotnrbytes == filesize);

	int r = fclose(f);
	assert(r == 0);

	
	// magic_number and header_length
	(void)memcpy(&ifh, m_data, IFH_SIZE);
	printf("byteorder = 0x%04x\n",ifh.byteorder);
	cout << "byteorder: " << ifh.byteorder << endl;


	if (ifh.byteorder == TIFF_LITTLE)
		cout << "LITTLE endian"<< endl;
	else if (ifh.byteorder == TIFF_BIG)
		cout << "BIG endian"<< endl;

	assert(ifh.byteorder == TIFF_LITTLE);//STK files MUST have little-endian byte order
	cout << "magic_number: " << ifh.magic_number << endl;
	
	//assert(ifh.magic_number == TIFF_MAGIC_NUMBER);
	char * memblock = (char *)&ifh;
	bool isSwapRequired = false;
	if (ifh.magic_number != TIFF_MAGIC_NUMBER)
	{
		isSwapRequired = true;
		if (isSwapRequired) {
			SWAP_2(memblock,0);
			SWAP_2(memblock,2);
			SWAP_4(memblock,4);
		}
	}
	assert(ifh.magic_number == TIFF_MAGIC_NUMBER);

	cout << "magic_number: " << ifh.magic_number << endl;
	int nextIFDoffset = -1;
	

	int	offset;
	
	offset = ifh.firstIFDoffset;
	int  counter = 0;

	while ( offset > 0 )

{
		counter = counter++;
		//cout << "IDF offset: " << offset << endl;
		
		short	num_directory_entries;
			//if(counter>0)
			//offset = newoffset + update*(counter-1);
			memcpy( &num_directory_entries, (unsigned char *)m_data + offset, sizeof( short ));
	/*	cout << "# of directory entries: " << num_directory_entries << endl;*/

		int	addr = offset + 2;
		for ( int i = 0; i < num_directory_entries; i++ ) {
			bool isValue=false;
			IFD_entry	ifd;
			memcpy( &ifd, (unsigned char *)m_data + addr, IFD_ENTRY_SIZE );
	
				if (ifd.count*IFD_TYPE_SIZE[ifd.type]>4){
			/*cout << "OFFSET: " << ifd.offset<< endl;	*/
		}else{
			/*cout << "VALUE: " << ifd.value<< endl;*/
			isValue = true;
		}
			switch (ifd.tag){
			
			case IFD_IMAGE_WIDTH:
				tiffh.numRows = ifd.value;
				/*cout << "  rows " << tiffh.numRows;*/
			break;
			case IFD_IMAGE_LENGTH:
				tiffh.numCols = ifd.value;
			break;
			}

			addr += IFD_ENTRY_SIZE;
		}

		
	
		memcpy( &offset, (unsigned char *)m_data + addr, sizeof( int ));
		
		}

	//tiffh.BitsPerSample = 8;
unsigned short **intensity_array;

int abcde, abcdef;
	int end = counter ;
	intensity_array = (unsigned short **)malloc((counter ) * sizeof(unsigned short *));
	if( intensity_array == (unsigned short **) NULL)
		printf("\nFailed to allocate the rows of the array");
	else 
		printf("\nSucessfully allocated the rows of the array");

	for ( abcdef = 0; abcdef < counter ; abcdef++)
	{
		intensity_array[abcdef] = (unsigned short *)malloc (tiffh.numCols*tiffh.numRows*sizeof(unsigned short));
		if ( intensity_array[abcdef] == (unsigned short *)NULL)
		{
			printf("\nFailed to allocate the columns of the array");
			printf("\nThe value of n is %d", abcdef);
			break;
		}
	}
	if ( abcdef == counter)
		printf("\n the entire array is allocated");
	else
		printf("\nThe entire array is not allocated");
	

	offset = ifh.firstIFDoffset;

int counter1 = 0;




	unsigned short min ;
	unsigned short max;
	while ( offset > 0 )
{
		
counter1++;
		
		short	num_directory_entries;
			//if(counter>0)
			//offset = newoffset + update*(counter-1);
			memcpy( &num_directory_entries, (unsigned char *)m_data + offset, sizeof( short ));
	/*	cout << "# of directory entries: " << num_directory_entries << endl;*/

		int	addr = offset + 2;
		for ( int i = 0; i < num_directory_entries; i++ ) {
			bool isValue=false;
			IFD_entry	ifd;
			memcpy( &ifd, (unsigned char *)m_data + addr, IFD_ENTRY_SIZE );
			/*cout << "  tag: " << ifd.tag;
			cout << "  hello\n" ;
			cout << "  type: " << ifd.type << "(" << IFD_TYPE_NAME[ ifd.type ] << ") ";
			cout << "  count: " << ifd.count << endl;*/

				if (ifd.count*IFD_TYPE_SIZE[ifd.type]>4){
			/*cout << "OFFSET: " << ifd.offset<< endl;	*/
		}else{
			/*cout << "VALUE: " << ifd.value<< endl;*/
			isValue = true;
		}
				switch (ifd.tag){
			
			case IFD_IMAGE_WIDTH:
				tiffh.numRows = ifd.value;
				/*cout << "  rows " << tiffh.numRows;*/
			break;
			case IFD_IMAGE_LENGTH:
				tiffh.numCols = ifd.value;
			break;


			case IFD_BITS_PER_SAMPLE:
				tiffh.BitsPerSample = ifd.value;
				tiffh.SamplesPerPixel = ifd.count;
				tiffh.bytespervoxel = tiffh.BitsPerSample/8;// * tiffh.SamplesPerPixel /8;
			break;
			
			case IFD_IMAGE_DESCRIPTION:
				tiffh.imageDescription =  new char[ifd.count];
				(void)memcpy(tiffh.imageDescription, (char *)m_data+ifd.offset,ifd.count);
			break;
			

			case IFD_STRIP_OFFSETS:
				{	
					/*cout << "----StripOffsets----"<<endl;*/
					int entrycount = ifd.count;
					tiffh.stripOffsets = new int[entrycount];
					for (int j=0; j<entrycount; j++)
					{
						if (isValue){
							tiffh.stripOffsets[j] = ifd.value;
						}else{
						(void)memcpy(&tiffh.stripOffsets[j], 
									(unsigned char *)m_data+ifd.offset+j*IFD_TYPE_SIZE[ifd.type], 
									IFD_TYPE_SIZE[ifd.type]);
						}
						//cout << tiffh.stripOffsets[j] << " " ;
					}
					//cout << endl;
				}
			break;
			/*case IFD_ZResolution:
				tiffh.ZResolution = ifd.value;
			break;
			*/
			
			case IFD_ROWS_PER_STRIP:
				tiffh.rowsPerStrip = ifd.value;
			break;
			case IFD_STRIP_BYTE_COUNTS:
				{	
					//cout << "----StripByteCounts----"<<endl;
					int entrycount = ifd.count;
					tiffh.stripByteCounts = new int[entrycount];
					for (int j=0; j<entrycount; j++)
					{
						if (isValue){
								tiffh.stripByteCounts[j] = ifd.value;
						}else{
							(void)memcpy(&tiffh.stripByteCounts[j], 
									(unsigned char *)m_data+ifd.offset+j*IFD_TYPE_SIZE[ifd.type], 
									IFD_TYPE_SIZE[ifd.type]);
						}
						//cout << tiffh.stripByteCounts[j] << " " ;
					}
					//cout << endl;
				}
			break;
		
		
		
		
				}
		
			
			addr += IFD_ENTRY_SIZE;
		}
		

	
	memcpy( &offset, (unsigned char *)m_data + addr, sizeof( int ));	
	//assert(counter==counter1);
	//tif file solis
	//int volSize = tiffh.numRows*tiffh.numCols*tiffh.bytespervoxel;
(void)memcpy(m_data, (unsigned char *) m_data+tiffh.stripOffsets[0],tiffh.numRows*tiffh.numCols*tiffh.bytespervoxel);
//int planeSize = tiffh.numRows * tiffh.numCols;

				//tif imageJ
				//memcpy( &offset, (unsigned char *)m_data + addr, sizeof( int ));	
				//int volSize = tiffh.numRows*tiffh.numCols*tiffh.numPlanes*tiffh.bytespervoxel;
				//(void)memcpy(m_data, (unsigned char *) m_data+tiffh.stripOffsets[0], tiffh.stripByteCounts[0]);
				//int planeSize = tiffh.numRows * tiffh.numCols;

//memcpy( &offset, (unsigned char *)m_data + addr, sizeof( int ));	
					//int volSize = tiffh.numRows*tiffh.numCols*tiffh.numPlanes*tiffh.bytespervoxel;
				//(void)memcpy(m_data, (unsigned char *) m_data+tiffh.stripOffsets[0], tiffh.stripByteCounts[0]);
				//int planeSize = tiffh.numRows * tiffh.numCols;


	//char seps[]   = " :,\t\n\r";
	//char *token;

	
	
		for (int iy=0; iy<tiffh.numCols; iy++)
		{
			for (int ix=0; ix<tiffh.numRows; ix++)
			{
				int index = iy*tiffh.numRows + ix;
				unsigned short c = (tiffh.bytespervoxel==1 ? ((unsigned char *)m_data)[index] : ((unsigned short *)m_data)[index]);
				//cout << c << " ";
				intensity_array[rowvariable][iy*tiffh.numRows + ix] = c;
				
					//fprintf( fw, "%u ", intensity_array[rowvariable][iy*tiffh.numRows + ix] );
			
			}
		}
		//cout << endl;
		//fprintf(fw, "\n");

	
		//memcpy( &offset, (unsigned char *)m_data + addr, sizeof( int ));
		rowvariable++;

	}
	//int inn = 3;
//assert(inn ==4);
	assert(counter==counter1);
unsigned short  **final_array;
float *average_array;
//unsigned short *actualaverage;

average_array = (float *)malloc(tiffh.numCols*tiffh.numRows * sizeof(float ));
	if( average_array == (float *) NULL)
		printf("\nFailed to allocate the rows of the array");
	else 
		printf("\nSucessfully allocated the rows of the array");



	final_array = (unsigned short **)malloc((end- start + 1 ) * sizeof(unsigned short *));
	if( final_array == (unsigned short **) NULL)
		printf("\nFailed to allocate the rows of the array");
	else 
		printf("\nSucessfully allocated the rows of the array");

	for ( abcdef = 0; abcdef < end - start+ 1; abcdef++)
	{
		final_array[abcdef] = (unsigned short *)malloc (tiffh.numCols*tiffh.numRows*sizeof(unsigned short));
		if ( final_array[abcdef] == (unsigned short *)NULL)
		{
			printf("\nFailed to allocate the columns of the array");
			printf("\nThe value of n is %d", abcdef);
			break;
		}
	}
	if ( abcdef == end -start + 1)
		printf("\n the entire array is allocated");
	else
		printf("\nThe entire array is not allocated");
for ( int i = 0; i < end - start +1; i++)
	{
		for (int j = 0; j< tiffh.numCols*tiffh.numRows; j++)
		{
			final_array[i][j] = intensity_array[start - 1 + i][j];
			//fprintf( fw, "%u ", final_array[i][j] );
		}
		//fprintf(fw, "\n");
	}
	

	for (int j = 0; j< tiffh.numCols*tiffh.numRows; j++)
		average_array[j] = 0;

for ( int i = 0; i < end - start +1; i++)
	{
		for (int j = 0; j< tiffh.numCols*tiffh.numRows; j++)
		average_array[j] = average_array[j]+ final_array[i][j];
	}
min = final_array[0][0];
max = final_array[0][0];
for ( abcdef = 0; abcdef < (end - start+ 1) ; abcdef++)
{
	for (abcde = 0; abcde < tiffh.numCols*tiffh.numRows; abcde++)
	{
		if ( final_array[abcdef][abcde] < min)
			min = final_array[abcdef][abcde];
	}
}

for ( abcdef = 0; abcdef < (end - start+ 1) ; abcdef++)
{
	for (abcde = 0; abcde < tiffh.numCols*tiffh.numRows; abcde++)
	{
		if ( final_array[abcdef][abcde] > max)
			max = final_array[abcdef][abcde];
	}
}
FILE *fp = fopen(trialstring1, "w");
fprintf(fp, "%d\n", tiffh.numCols);
fprintf(fp, "%d\n", tiffh.numRows);
fprintf(fp, "%d\n", counter);
fprintf(fp, "%d\n", max);

		for (int j = 0; j< tiffh.numCols*tiffh.numRows; j++)
		{
		average_array[j] = average_array[j]/(end - start +1);
		fprintf(fp,"%f\n", average_array[j]);
	}

min = final_array[0][0];
max = final_array[0][0];
for ( abcdef = 0; abcdef < (end - start+ 1) ; abcdef++)
{
	for (abcde = 0; abcde < tiffh.numCols*tiffh.numRows; abcde++)
	{
		if ( final_array[abcdef][abcde] < min)
			min = final_array[abcdef][abcde];
	}
}

for ( abcdef = 0; abcdef < (end - start+ 1) ; abcdef++)
{
	for (abcde = 0; abcde < tiffh.numCols*tiffh.numRows; abcde++)
	{
		if ( final_array[abcdef][abcde] > max)
			max = final_array[abcdef][abcde];
	}
}
fclose(fp);
//FILE *fw = fopen("check.txt", "w");
//for (int i = 0; i<tiffh.numCols*tiffh.numRows; i++)
//fprintf( fw, "%d\n ", intensity_array[100][i] );
	

done:
	if (p->str_imFCS2)
		DisposeHandle(p->str_imFCS2);			 //we need to get rid of input parameters 
	if (p->str_imFCS3)
		DisposeHandle(p->str_imFCS3);
	// we need to get rid of input parameters 
	//int c = 67;
	 p->result =min;
if(m_data != NULL)
free(m_data);
	return(err);
	return(err);
}




static long
RegisterFunction()
{
	int funcIndex;

	/*	NOTE:
		Most XOPs should return a result of NIL in response to the FUNCADDRS message.
		See XOP manual "Restrictions on Direct XFUNCs" section.
	*/

	funcIndex = GetXOPItem(0);		/* which function invoked ? */
	switch (funcIndex) {
		case 0:						/* str1 = xstrcat0(str2, str3) */
			return((long)xstrcat);	/* this uses the direct call method */
			break;
		case 1:						/* str1 = xstrcat1(str2, str3) */
			return(NIL);			/* this uses the message call method */
			break;
	}
	return(NIL);
}

static int
DoFunction()
{
	int funcIndex;
	void *p;				/* pointer to structure containing function parameters and result */
	int err;				/* error code returned by function */

	funcIndex = GetXOPItem(0);		/* which function invoked ? */
	p = (void *)GetXOPItem(1);		/* get pointer to params/result */
	switch (funcIndex) {
		case 1:						/* str1 = xstrcat2(str2, str3) */
//			err = xstrcat(p);
			break;
		default:
			err = UNKNOWN_XFUNC;
			break;
	}
	return(err);
}

/*	XOPEntry()

	This is the entry point from the host application to the XOP for all messages after the
	INIT message.
*/

static void
XOPEntry(void)
{	
	long result = 0;

	switch (GetXOPMessage()) {
		case FUNCTION:								/* our external function being invoked ? */
			result = DoFunction();
			break;
			
		case FUNCADDRS:
			result = RegisterFunction();
			break;
	}
	SetXOPResult(result);
}

HOST_IMPORT void
main(IORecHandle ioRecHandle)
{	
	XOPInit(ioRecHandle);							/* do standard XOP initialization */
	SetXOPEntry(XOPEntry);							/* set entry point for future calls */

	if (igorVersion < 200)
		SetXOPResult(REQUIRES_IGOR_200);
	else
		SetXOPResult(0L);
}



